AddCSLuaFile( "shared.lua" )
include('shared.lua')

function ENT:SpawnFunction( ply, tr )
	if ( !tr.Hit ) then return end
	local SpawnPos = tr.HitPos + tr.HitNormal * 16
	local ent = ents.Create(self.EntName)
	ent:SetPos( SpawnPos )
	ent:Spawn()
	ent:Activate()
	return ent
end

function ENT:Initialize()
	self:SetModel(self.model)
	self:SetMoveType( MOVETYPE_NONE )
	self:SetSolid(SOLID_BBOX)
	self:SetAngles(Angle(0,0,0))
	self:DrawShadow( true )
	self:DropToFloor()
	self.Available = true
	self:SetCollisionGroup( COLLISION_GROUP_WORLD )
	self:SetRenderMode( RENDERMODE_TRANSALPHA )
end

function ENT:Think()
	if self.ReEnabled and CurTime() >= self.ReEnabled then
		self.ReEnabled = nil
		self.Available = true
		self:SetNoDraw(false)
	end
	for k,v in pairs (player.GetAll()) do
		if v:GetPos():Distance(self:GetPos()) < 50 and self.Available == true and v:Alive() then
			local ammoCount = v:GetAmmoCount(self.AmmoType)
			if v:GetAmmoCount(self.AmmoType) >= self.MaxAmmo then return end
			self.Available = false
			self:SetNoDraw(true)
			self.ReEnabled = CurTime() + 30
			v:EmitSound("world/ammo.wav", 85, math.random(95,105))
			if (ammoCount < self.MaxAmmo) then
				v:SetAmmo( math.min( ammoCount + self.AmmoAmount, self.MaxAmmo ), self.AmmoType )
			end
		end
	end
end